define(['FitnessActivityController', 'FitnessConstants'], function() {
	'use strict';

	describe("The Fitness Summary Controller", function (){
		var q,
			controller,
			scope,
			state,
			deferred,
			goalDeferred,
			focusServiceMock,
			goalServiceMock,
			goalGraphServiceMock,
			fitnessServiceMock,
			globalDelayTrackerMock,
			goalsServiceFetchSpy,
			idGetterSpy,
			fetchSpy,
			dataPointers = {
				list: [{}],
				filters: null
			},
			goalDataPointers = {
				list: [{endDate: '01/01/2016'}],
				filters: null
			},
			sectionName = "fitnessActivities",
			itemId = "item_id",
			parsedItemId = "parsed_item_id",
			mockResponse = {},
            goalGraphAccessibleMock,
            activityGraphServiceMock,
            remindersServiceMock;

		beforeEach(function() {
			module('angularTemplateApp');

			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);

			globalDelayTrackerMock = jasmine.createSpy('globalDelayTracker');
			goalServiceMock = jasmine.createSpyObj('WeeklyGoalsService', ['instance']);
			fitnessServiceMock = jasmine.createSpyObj('FitnessService', ['instance']);
			goalGraphServiceMock = jasmine.createSpyObj('GoalGraphService', ['getGraphConfig']);
            activityGraphServiceMock = jasmine.createSpyObj('FitnessActivityGraphService', ['getGraphConfig']);
            goalGraphAccessibleMock = jasmine.createSpyObj('GoalGraphAccessibilityService', ['getScreenReaderTexts']);
            remindersServiceMock = jasmine.createSpyObj('FitnessRemindersService', ['init', 'getReminder']);
            remindersServiceMock.getReminder.and.returnValue({then: function () {}});


            module(function($provide){
				$provide.value('FitnessService', fitnessServiceMock);
				$provide.value('WeeklyGoalsService', goalServiceMock);
				$provide.value('GoalGraphService', goalGraphServiceMock);
                $provide.value('FitnessActivityGraphService', activityGraphServiceMock);
                $provide.value('GoalGraphAccessibilityService', goalGraphAccessibleMock);
                $provide.value('focusService', focusServiceMock);
				$provide.value('globalDelayTracker', globalDelayTrackerMock);
                $provide.value('FitnessRemindersService', remindersServiceMock);
            });

			inject(function($controller, $rootScope, FitnessConstants, formatter, $state, $q) {
				scope = $rootScope.$new();
				state = $state;
				q = $q;

				goalDeferred = q.defer();
				goalDeferred.resolve({});
				goalsServiceFetchSpy = jasmine.createSpy('goalsServiceFetchSpy').and.returnValue(goalDeferred.promise);
				goalServiceMock.instance.and.returnValue({
					dataPointers: goalDataPointers,
					fetch: goalsServiceFetchSpy
				});

				deferred = q.defer();
				deferred.resolve({});
				fetchSpy = jasmine.createSpy("fetchSpy").and.returnValue(deferred.promise);
				fitnessServiceMock.instance.and.returnValue({
					dataPointers: dataPointers,
					idGetter: idGetterSpy,
					fetch: fetchSpy
				});

				state.current.data = {
					sectionName: sectionName
				};

				controller = $controller('FitnessActivityController', { $scope: scope });
			});
		});

		describe("when the controller loads", function () {
			it("should be defined and correct", function() {
				expect(scope.details).toEqual({});
				expect(scope.globalDelayTracker).toEqual(globalDelayTrackerMock);
				expect(focusServiceMock.focusMain).toHaveBeenCalled();
				expect(scope.today).toEqual(jasmine.any(Date));
				expect(scope.sectionTitle).toEqual("Fitness Activity");
			});
		});

		describe("when an active goal is retrieved", function (){
			it("should retrieve the goal", function () {
				scope.$apply();
				expect(goalsServiceFetchSpy).toHaveBeenCalledWith({activeFlag : true});
				expect(scope.details).toEqual({endDate: '01/01/2016'});

				expect(goalGraphServiceMock.getGraphConfig).toHaveBeenCalledWith(scope.details);
				expect(scope.graphConfig).toEqual(goalGraphServiceMock.getGraphConfig());

                expect(goalGraphAccessibleMock.getScreenReaderTexts).toHaveBeenCalledWith(scope.details);
                expect(scope.screenReaderText).toEqual(goalGraphAccessibleMock.getScreenReaderTexts());

                expect(activityGraphServiceMock.getGraphConfig).toHaveBeenCalledWith(scope.filter);
			});
		});
	});
});


